Attribute VB_Name = "mdDrawDatum"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to create a datum

Function DrawDatum(Design, drawdoc, graph)

Rem To get the global application object
GetApplicationObject

'Get the Drawing Object pointer
Dim draw As aDrawing
Set draw = drawdoc.GetDrawing

Dim ddetail As aDesignDetail
Set ddetail = draw.GetDetail(Design, False)

'get the paper geometry
Dim geom As zGeometry
Set geom = drawdoc.GetPaperGeometry(graph)

'Creating Datum
Dim tolerance1 As aDatum
Set tolerance1 = app.GetClass("Datum").CreateDatum(ddetail, geom)
Dim callout1 As aDatumCallout
Set callout1 = app.GetClass("DatumCallout").CreateDatumCallout(tolerance1)

'Set the position for the dimension line
Dim textLocation1 As ZVector
Set textLocation1 = app.GetClass("Vector").CreateVector(0.2, 0.2, 0)

Dim calloutgroup1 As aCalloutGroup
' 0.005 is the text height
Set calloutgroup1 = app.GetClass("CalloutGroup").CreateCalloutGroup(callout1, textLocation1, 0.005)
calloutgroup1.SetControlPoint 1, textLocation1

draw.AddCalloutGroup calloutgroup1

'create feature leader
Dim leader1 As aLeader
Set geom = tolerance1.GetGeometry()
Set leader1 = app.GetClass("FeatureLeader").CreateFeatureLeader(calloutgroup1, geom)

' create newpoint which to be termination point
Dim newpoint As ZVector
Set newpoint = app.GetClass("Vector").CreateVector(0.1, 0.1, 0.1)

leader1.SetTerminationPoint newpoint
leader1.SetPerpendicular
leader1.SetCalloutGroup calloutgroup1

'get the callout group
Dim calloutgroup2 As aCalloutGroup
Set calloutgroup2 = leader1.GetCalloutGroup()

'set terminator and shoulder length
leader1.SetTerminator (1)
leader1.SetShoulderLength (0.1)
leader1.RemoveJogPoints

draw.AddLeader leader1

'Add CenterLine
'To be done



End Function
